/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Portability layer equivalent of <Shark.h>.
 *
 * $Id: Shark-gpl.h,v 1.11 2001/09/25 19:03:47 dcraft Exp $
 *
 * $Log: Shark-gpl.h,v $
 * Revision 1.11  2001/09/25 19:03:47  dcraft
 * OPEN_OVERLOAD no longer needed.  Move cxiKiobuf_t into cxiIOBuffer.C
 *
 * Revision 1.10  2001/09/22 20:07:55  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.9  2001/08/10 18:22:30  gjertsen
 * Put errno predeclaration for kernel code in Shark-gpl.h.
 *
 * Revision 1.8  2001/05/25 14:48:17  gjertsen
 * Minor fixes to get IA64 code to compile again.
 *
 * Revision 1.7  2001/04/10 21:10:27  wyllie
 * Use EXTERNC macro to simplify declarations that need to work on both C
 * and C++.
 *
 * Revision 1.6  2001/01/08 20:48:50  gjertsen
 * Minor code cleanup. No functional changes.
 *
 * Revision 1.5  2000/12/18 13:53:10  gjertsen
 * More cleanup of comments/documentation.
 *
 * Revision 1.4  2000/12/15 13:56:31  gjertsen
 * Clean up documentation.
 *
 * Revision 1.3  2000/11/09 15:19:35  gjertsen
 * Definition for PAGE_SIZE is pulled in separately for this code.
 *
 * Revision 1.2  2000/11/06 19:56:07  gjertsen
 * Linux code cleanup and put in build safeguards.
 *
 * Revision 1.1  2000/11/02 19:46:16  gjertsen
 * Linux code split. Pull out NBD stuff.
 *
 */

#ifndef _h_shark_gpl
#define _h_shark_gpl

/* Indicate portability source code */
#define GPFS_GPL

/* Try to ensure that this is the first file included in source code */
#ifdef _KERNEL
#if defined(_LINUX_TYPES_H) || defined(_LINUX_KERNEL_H) || defined(_LINUX_MODULE_H)
#error Shark-gpl.h must be included first; kernel file already seen
#endif
#else  /* !_KERNEL */
#ifdef _FEATURES_H
#error Shark-gpl.h must be included first; features.h already seen
#endif
#endif /* _KERNEL */

#ifdef _KERNEL
/* errno needs to be predeclared for kernel code */
extern int errno;

/* Include <linux/types.h> in kernel code for cxiTypes.h */
#include <linux/types.h>
#endif /* _KERNEL */
#include <cxiTypes.h>

/* Avoid various AIX specific header includes */
#define _H_BUF
#define _H_XMEM
#define _H_SLEEP
#define _H_LOCKL
#define _H_LOCK_DEFINE

/* Virtual memory page size.  Used for aligning I/O buffers. */
/* Note that the page size can be adjusted for the IA64 Linux kernel */
#include <asm/page.h>     /* PAGE_SIZE */

#ifndef NOOP
#define NOOP ((void)0)
#endif
#endif /* _h_shark_gpl */
